/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;

public class UpdateUpgradePacket {
    private final boolean newUpgrade;
    private final ResourceLocation upgradeID;
    private final int planeEntityID;
    private ServerWorld serverWorld;
    private PacketBuffer packetBuffer;

    public UpdateUpgradePacket(ResourceLocation upgradeID, int planeEntityID, ServerWorld serverWorld) {
        this(upgradeID, planeEntityID, serverWorld, false);
    }

    public UpdateUpgradePacket(ResourceLocation upgradeID, int planeEntityID, ServerWorld serverWorld, boolean newUpgrade) {
        this.upgradeID = upgradeID;
        this.planeEntityID = planeEntityID;
        this.serverWorld = serverWorld;
        this.newUpgrade = newUpgrade;
    }

    public UpdateUpgradePacket(PacketBuffer buffer) {
        this.newUpgrade = buffer.readBoolean();
        this.planeEntityID = buffer.func_150792_a();
        this.upgradeID = buffer.func_192575_l();
        this.packetBuffer = buffer;
    }

    public void toBytes(PacketBuffer buffer) {
        buffer.writeBoolean(this.newUpgrade);
        PlaneEntity planeEntity = (PlaneEntity)this.serverWorld.func_73045_a(this.planeEntityID);
        planeEntity.writeUpdateUpgradePacket(this.upgradeID, buffer);
    }

    public void handle(Supplier<NetworkEvent.Context> ctxSup) {
        NetworkEvent.Context ctx = ctxSup.get();
        ctx.enqueueWork(() -> {
            ClientWorld clientWorld = Minecraft.func_71410_x().field_71441_e;
            ((PlaneEntity)clientWorld.func_73045_a(this.planeEntityID)).readUpdateUpgradePacket(this.upgradeID, this.packetBuffer, this.newUpgrade);
        });
        ctx.setPacketHandled(true);
    }
}

